/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientSocketFactory;
import HTTPClient.IHTTPClientDNSResolver;
import HTTPClient.SocksClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

final class EstablishConnection
extends Thread {
    String actual_host;
    int actual_port;
    IOException exception;
    Socket sock;
    SocksClient Socks_client;
    volatile boolean m_bClose;
    HTTPClientSocketFactory m_socketFactory = null;
    IHTTPClientDNSResolver m_dnsResolver = null;

    EstablishConnection(String host, int port, SocksClient socks, HTTPClientSocketFactory socketFactory, IHTTPClientDNSResolver a_dnsResolver) {
        super("EstablishConnection (" + host + ":" + port + ")");
        try {
            this.setDaemon(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.actual_host = host;
        this.actual_port = port;
        this.Socks_client = socks;
        this.exception = null;
        this.sock = null;
        this.m_bClose = false;
        this.m_socketFactory = socketFactory;
        this.m_dnsResolver = a_dnsResolver;
    }

    public void run() {
        block10: {
            try {
                if (this.Socks_client != null) {
                    this.sock = this.Socks_client.getSocket(this.actual_host, this.actual_port);
                    break block10;
                }
                InetAddress[] addr_list = null;
                addr_list = this.m_dnsResolver != null ? this.m_dnsResolver.getAllByName(this.actual_host) : InetAddress.getAllByName(this.actual_host);
                for (int idx = 0; idx < addr_list.length; ++idx) {
                    try {
                        this.sock = this.m_socketFactory == null ? new Socket(addr_list[idx], this.actual_port) : this.m_socketFactory.connect(addr_list[idx], this.actual_port);
                        break;
                    }
                    catch (SocketException se) {
                        if (idx != addr_list.length - 1 && !this.m_bClose) continue;
                        this.exception = se;
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
            catch (Exception ioe) {
                this.exception = new IOException("UnknownIOExcpetion in EstablishConnection: " + ioe.getMessage());
            }
        }
        if (this.m_bClose) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock = null;
        }
    }

    IOException getException() {
        return this.exception;
    }

    Socket getSocket() {
        return this.sock;
    }

    void forget() {
        this.m_bClose = true;
    }
}

