/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.DemultiplexorInputStream;
import HTTPClient.ExtBufferedInputStream;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientUtil;
import HTTPClient.LazyReadInputStream;
import HTTPClient.LinkedList;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.RetryException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

class StreamDemultiplexor
implements GlobalConstants {
    private int Protocol;
    private HTTPConnection Connection;
    private DemultiplexorInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private static SocketTimeout TimerThread = null;
    private LinkedList RespHandlerList;
    private int chunk_len;
    private static byte[] hdr_end = new byte[]{13, 10, 13, 10};
    private static int[] hdr_cmp = HttpClientUtil.compile_search(hdr_end);
    private boolean hdr_term_set = false;
    private boolean trl_term_set = false;
    private int cur_timeout = 0;
    private boolean m_httpConnectCompatibilityMode;
    private Socket m_hiddenSocket;

    StreamDemultiplexor(int protocol, Socket sock, HTTPConnection connection, boolean a_httpConnectCompatibilityMode) throws IOException {
        this.Protocol = protocol;
        this.Connection = connection;
        this.RespHandlerList = new LinkedList();
        this.m_httpConnectCompatibilityMode = a_httpConnectCompatibilityMode;
        this.m_hiddenSocket = null;
        this.init(sock);
    }

    private void init(Socket sock) throws IOException {
        this.Sock = sock;
        this.Stream = this.m_httpConnectCompatibilityMode ? new LazyReadInputStream(sock.getInputStream()) : new ExtBufferedInputStream(sock.getInputStream());
        this.MarkedForClose = null;
        this.chunk_len = -1;
        this.Timer = TimerThread.setTimeout(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Response resp_handler, Request req) throws RetryException {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.addToEnd(new ResponseHandler(resp_handler, req, this));
        }
    }

    RespInputStream getStream(Response resp) {
        ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
        while (resph != null && resph.resp != resp) {
            resph = (ResponseHandler)this.RespHandlerList.next();
        }
        if (resph != null) {
            return resph.stream;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket releaseSocket() {
        Socket releasedSocket = null;
        StreamDemultiplexor streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            if (this.m_httpConnectCompatibilityMode) {
                try {
                    LinkedList linkedList = this.RespHandlerList;
                    synchronized (linkedList) {
                        ResponseHandler currentResponseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
                        while (currentResponseHandler != null) {
                            ResponseHandler nextResponseHandler = (ResponseHandler)this.RespHandlerList.next();
                            if (nextResponseHandler == null) {
                                currentResponseHandler.resp.getStatusCode();
                            }
                            currentResponseHandler = nextResponseHandler;
                        }
                        this.close(null, false);
                    }
                    releasedSocket = this.m_hiddenSocket;
                    this.m_hiddenSocket = null;
                    this.m_httpConnectCompatibilityMode = false;
                }
                catch (IOException e) {
                    this.m_httpConnectCompatibilityMode = false;
                    this.close(null, false);
                }
            }
        }
        return releasedSocket;
    }

    public boolean isHttpConnectCompatibilityModeUsed() {
        return this.m_httpConnectCompatibilityMode;
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    int read(byte[] b, int off, int len, ResponseHandler resph, int timeout) throws IOException {
        ResponseHandler head;
        if (resph.exception != null) {
            throw (IOException)resph.exception.fillInStackTrace();
        }
        if (resph.eof) {
            return -1;
        }
        while ((head = (ResponseHandler)this.RespHandlerList.getFirst()) != null && head != resph) {
            try {
                head.stream.readAll(timeout);
            }
            catch (IOException ioe) {
                if (ioe instanceof InterruptedIOException) {
                    throw ioe;
                }
                throw (IOException)resph.exception.fillInStackTrace();
            }
        }
        StreamDemultiplexor streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            if (resph.exception != null) {
                throw (IOException)resph.exception.fillInStackTrace();
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                int rcvd = -1;
                if (timeout != this.cur_timeout) {
                    try {
                        this.Sock.setSoTimeout(timeout);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.cur_timeout = timeout;
                }
                switch (resph.resp.cd_type) {
                    case 0: {
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 1: {
                        if (!this.hdr_term_set) {
                            this.Stream.setTerminator(hdr_end, hdr_cmp);
                            this.hdr_term_set = true;
                        }
                        if (this.Stream.atEnd()) {
                            this.Stream.setTerminator(null, null);
                            this.hdr_term_set = false;
                            rcvd = 0;
                        } else {
                            rcvd = this.Stream.read(b, off, len);
                        }
                        if (rcvd != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        rcvd = -1;
                        this.close(resph);
                        break;
                    }
                    case 3: {
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd != -1) break;
                        this.close(resph);
                        break;
                    }
                    case 4: {
                        int cl = resph.resp.ContentLength;
                        if (len > cl - resph.stream.count) {
                            len = cl - resph.stream.count;
                        }
                        if ((rcvd = this.Stream.read(b, off, len)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (resph.stream.count + rcvd != cl) break;
                        this.close(resph);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1) {
                            this.chunk_len = Codecs.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0) {
                            if (len > this.chunk_len) {
                                len = this.chunk_len;
                            }
                            if ((rcvd = this.Stream.read(b, off, len)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= rcvd;
                            if (this.chunk_len != 0) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1;
                            break;
                        }
                        if (this.trl_term_set || !this.Stream.startsWithCRLF()) {
                            if (!this.trl_term_set) {
                                this.Stream.setTerminator(hdr_end, hdr_cmp);
                                this.trl_term_set = true;
                            }
                            resph.resp.readTrailers(this.Stream);
                            if (!this.Stream.atEnd()) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.Stream.setTerminator(null, null);
                            this.trl_term_set = false;
                        }
                        rcvd = -1;
                        this.close(resph);
                        this.chunk_len = -1;
                        break;
                    }
                    case 6: {
                        resph.setupBoundary(this.Stream);
                        rcvd = this.Stream.read(b, off, len);
                        if (rcvd == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (!this.Stream.atEnd()) break;
                        this.Stream.setTerminator(null, null);
                        this.close(resph);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + resph.resp.cd_type);
                    }
                }
                this.restartTimer();
                return rcvd;
            }
            catch (InterruptedIOException ie) {
                this.restartTimer();
                throw ie;
            }
            catch (IOException ioe) {
                this.close(ioe, true);
                throw resph.exception;
            }
            catch (ParseException pe) {
                this.close(new IOException(pe.toString()), true);
                throw resph.exception;
            }
        }
    }

    synchronized long skip(long num, ResponseHandler resph) throws IOException {
        if (resph.exception != null) {
            throw (IOException)resph.exception.fillInStackTrace();
        }
        if (resph.eof) {
            return 0L;
        }
        byte[] dummy = new byte[(int)num];
        int rcvd = this.read(dummy, 0, (int)num, resph, 0);
        if (rcvd == -1) {
            return 0L;
        }
        return rcvd;
    }

    synchronized int available(ResponseHandler resph) throws IOException {
        int avail = this.Stream.available();
        if (resph == null) {
            return avail;
        }
        if (resph.exception != null) {
            throw (IOException)resph.exception.fillInStackTrace();
        }
        if (resph.eof) {
            return 0;
        }
        switch (resph.resp.cd_type) {
            case 0: {
                return avail;
            }
            case 1: {
                return avail > 0 ? 1 : 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return avail;
            }
            case 4: {
                int cl = resph.resp.ContentLength;
                return avail < (cl -= resph.stream.count) ? avail : cl;
            }
            case 5: {
                return avail;
            }
            case 6: {
                return avail;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + resph.resp.cd_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close(IOException exception, boolean was_reset) {
        if (this.Sock == null) {
            return;
        }
        if (this.m_httpConnectCompatibilityMode) {
            this.Stream = new ExtBufferedInputStream(new ByteArrayInputStream(new byte[0]));
        }
        try {
            this.Stream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.m_httpConnectCompatibilityMode) {
            this.m_hiddenSocket = this.Sock;
        } else {
            try {
                this.Sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (exception != null) {
            LinkedList linkedList = this.RespHandlerList;
            synchronized (linkedList) {
                this.retry_requests(exception, was_reset);
            }
        }
    }

    private void retry_requests(IOException exception, boolean was_reset) {
        RetryException first = null;
        RetryException prev = null;
        ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
        while (resph != null) {
            if (resph.resp.got_headers) {
                resph.exception = exception;
            } else {
                RetryException tmp = new RetryException(exception.getMessage());
                if (first == null) {
                    first = tmp;
                }
                tmp.request = resph.request;
                tmp.response = resph.resp;
                tmp.exception = exception;
                tmp.conn_reset = was_reset;
                tmp.first = first;
                tmp.addToListAfter(prev);
                prev = tmp;
                resph.exception = tmp;
            }
            this.RespHandlerList.remove(resph);
            resph = (ResponseHandler)this.RespHandlerList.next();
        }
    }

    synchronized void close(ResponseHandler resph) {
        if (resph != (ResponseHandler)this.RespHandlerList.getFirst()) {
            return;
        }
        resph.eof = true;
        this.RespHandlerList.remove(resph);
        if (resph == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeSocketIfAllStreamsClosed() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
            while (resph != null && resph.stream.closed) {
                if (resph == this.MarkedForClose) {
                    ResponseHandler tmp;
                    do {
                        tmp = (ResponseHandler)this.RespHandlerList.getFirst();
                        this.RespHandlerList.remove(tmp);
                    } while (tmp != resph);
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                    return;
                }
                resph = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void markForClose(Response resp) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.RespHandlerList.getFirst() == null) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                return;
            }
        }
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        ResponseHandler lasth = null;
        ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
        while (resph != null) {
            if (resph.resp == resp) {
                this.MarkedForClose = resph;
                this.closeSocketIfAllStreamsClosed();
                return;
            }
            if (this.MarkedForClose == resph) {
                return;
            }
            lasth = resph;
            resph = (ResponseHandler)this.RespHandlerList.next();
        }
        if (lasth == null) {
            return;
        }
        this.MarkedForClose = lasth;
        this.closeSocketIfAllStreamsClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler resph = (ResponseHandler)this.RespHandlerList.enumerate();
            while (resph != null) {
                if (resph.resp.http_resp != null) {
                    resph.resp.http_resp.markAborted();
                }
                if (resph.exception == null) {
                    resph.exception = new IOException("Request aborted by user");
                }
                resph = (ResponseHandler)this.RespHandlerList.next();
            }
            if (this.Sock != null) {
                try {
                    if (!this.m_httpConnectCompatibilityMode) {
                        try {
                            this.Sock.setSoLinger(false, 0);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (this.m_httpConnectCompatibilityMode) {
                        this.Stream = new ExtBufferedInputStream(new ByteArrayInputStream(new byte[0]));
                    }
                    try {
                        this.Stream.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (this.m_httpConnectCompatibilityMode) {
                        this.m_hiddenSocket = this.Sock;
                    } else {
                        try {
                            this.Sock.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.Connection.DemuxList.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseHttpConnectResources() {
        StreamDemultiplexor streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            this.m_httpConnectCompatibilityMode = false;
            if (this.m_hiddenSocket != null) {
                try {
                    this.m_hiddenSocket.getInputStream().close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.m_hiddenSocket.getOutputStream().close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.m_hiddenSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_hiddenSocket = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.m_hiddenSocket != null) {
            try {
                this.m_hiddenSocket.getInputStream().close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.m_hiddenSocket.getOutputStream().close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.m_hiddenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_hiddenSocket = null;
        }
        this.m_httpConnectCompatibilityMode = false;
        this.close(null, false);
        super.finalize();
    }

    public String toString() {
        String prot;
        switch (this.Protocol) {
            case 0: {
                prot = "HTTP";
                break;
            }
            case 1: {
                prot = "HTTPS";
                break;
            }
            case 2: {
                prot = "SHTTP";
                break;
            }
            case 3: {
                prot = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return this.getClass().getName() + "[Protocol=" + prot + "]";
    }

    static {
        TimerThread = new SocketTimeout(60);
        TimerThread.start();
    }

    private static class SocketTimeout
    extends Thread
    implements GlobalConstants {
        private TimeoutEntry[] time_list;
        private int current;

        SocketTimeout(int secs) {
            super("SocketTimeout");
            try {
                this.setDaemon(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            this.setPriority(10);
            this.time_list = new TimeoutEntry[secs];
            for (int idx = 0; idx < secs; ++idx) {
                this.time_list[idx] = new TimeoutEntry(null);
                this.time_list[idx].next = this.time_list[idx].prev = this.time_list[idx];
            }
            this.current = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimeoutEntry setTimeout(StreamDemultiplexor demux) {
            TimeoutEntry entry = new TimeoutEntry(demux);
            TimeoutEntry[] timeoutEntryArray = this.time_list;
            synchronized (this.time_list) {
                entry.next = this.time_list[this.current];
                entry.prev = this.time_list[this.current].prev;
                entry.prev.next = entry;
                entry.next.prev = entry;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            block8: while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                Object ie = this.time_list;
                // MONITORENTER : this.time_list
                TimeoutEntry entry = this.time_list[this.current].next;
                while (entry != this.time_list[this.current]) {
                    entry.restart = false;
                    entry = entry.next;
                }
                ++this.current;
                if (this.current >= this.time_list.length) {
                    this.current = 0;
                }
                entry = this.time_list[this.current].next;
                TimeoutEntry currentEntry = this.time_list[this.current];
                // MONITOREXIT : ie
                while (true) {
                    if (entry == currentEntry) continue block8;
                    try {
                        ie = entry.demux;
                        // MONITORENTER : ie
                        if (entry.alive && !entry.hyber) {
                            entry.demux.markForClose(null);
                            entry.kill();
                        }
                        // MONITOREXIT : ie
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    entry = entry.next;
                }
                break;
            }
        }

        private class TimeoutEntry {
            boolean restart = false;
            boolean hyber = false;
            boolean alive = true;
            StreamDemultiplexor demux;
            TimeoutEntry next = null;
            TimeoutEntry prev = null;

            TimeoutEntry(StreamDemultiplexor demux) {
                this.demux = demux;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void reset() {
                this.hyber = false;
                if (this.restart) {
                    return;
                }
                this.restart = true;
                TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
                synchronized (timeoutEntryArray) {
                    this.next.prev = this.prev;
                    this.prev.next = this.next;
                    this.next = SocketTimeout.this.time_list[SocketTimeout.this.current];
                    this.prev = ((SocketTimeout)SocketTimeout.this).time_list[((SocketTimeout)SocketTimeout.this).current].prev;
                    this.prev.next = this;
                    this.next.prev = this;
                }
            }

            void hyber() {
                if (this.alive) {
                    this.hyber = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void kill() {
                this.alive = false;
                this.restart = false;
                this.hyber = false;
                TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
                synchronized (timeoutEntryArray) {
                    this.next.prev = this.prev;
                    this.prev.next = this.next;
                }
            }
        }
    }
}

