/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.ISymCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class SymCipherCTR
implements ISymCipher {
    Cipher m_aesEngine1;
    Cipher m_aesEngine2;
    byte[] m_iv1 = null;
    byte[] m_iv2 = null;
    byte[] m_aesKeys;

    public SymCipherCTR() {
        int i;
        try {
            this.m_aesEngine1 = Cipher.getInstance("AES/CTR/NoPadding");
            this.m_aesEngine2 = Cipher.getInstance("AES/CTR/NoPadding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_aesKeys = null;
        this.m_iv1 = new byte[16];
        for (i = 0; i < 16; ++i) {
            this.m_iv1[i] = 0;
        }
        this.m_iv2 = new byte[16];
        for (i = 0; i < 16; ++i) {
            this.m_iv2[i] = 0;
        }
    }

    public String toString() {
        try {
            Provider p = this.m_aesEngine1.getProvider();
            return this.m_aesEngine1.getAlgorithm() + "[Provider: " + p.getName() + " (Version: " + p.getVersion() + ")]";
        }
        catch (Throwable throwable) {
            return "unknown";
        }
    }

    public synchronized int setEncryptionKeyAES(byte[] key) {
        return this.setEncryptionKeyAES(key, 0, 16);
    }

    public synchronized int setEncryptionKeyAES(byte[] key, int offset, int len) {
        try {
            int i;
            this.m_aesKeys = new byte[16];
            System.arraycopy(key, offset, this.m_aesKeys, 0, 16);
            if (len == 16) {
                for (i = 0; i < 16; ++i) {
                    this.m_iv1[i] = 0;
                    this.m_iv2[i] = 0;
                }
            } else {
                for (i = 0; i < 16; ++i) {
                    this.m_iv1[i] = key[i + 16 + offset];
                    this.m_iv2[i] = key[i + 16 + offset];
                }
            }
            IvParameterSpec ivSpec1 = new IvParameterSpec(this.m_iv1);
            IvParameterSpec ivSpec2 = new IvParameterSpec(this.m_iv2);
            SecretKeySpec aesKey1 = new SecretKeySpec(this.m_aesKeys, "AES");
            SecretKeySpec aesKey2 = new SecretKeySpec(this.m_aesKeys, "AES");
            this.m_aesEngine1.init(1, (Key)aesKey1, ivSpec1);
            this.m_aesEngine2.init(2, (Key)aesKey2, ivSpec2);
            return 0;
        }
        catch (Exception e) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public synchronized int setEncryptionKeysAES(byte[] keys) {
        try {
            if (keys.length == 16) {
                return this.setEncryptionKeyAES(keys);
            }
            this.m_aesKeys = new byte[32];
            System.arraycopy(keys, 0, this.m_aesKeys, 0, 32);
            for (int i = 0; i < 16; ++i) {
                this.m_iv1[i] = 0;
                this.m_iv2[i] = 0;
            }
            IvParameterSpec ivSpec1 = new IvParameterSpec(this.m_iv1);
            IvParameterSpec ivSpec2 = new IvParameterSpec(this.m_iv2);
            SecretKeySpec aesKey1 = new SecretKeySpec(this.m_aesKeys, 0, 16, "AES");
            SecretKeySpec aesKey2 = new SecretKeySpec(this.m_aesKeys, 16, 16, "AES");
            this.m_aesEngine1.init(1, (Key)aesKey1, ivSpec1);
            this.m_aesEngine2.init(2, (Key)aesKey2, ivSpec2);
            return 0;
        }
        catch (Exception e) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public byte[] getKeys() {
        return this.m_aesKeys;
    }

    public synchronized void setIV2(byte[] buff) {
        for (int i = 0; i < 16; ++i) {
            this.m_iv2[i] = buff[i];
        }
        IvParameterSpec ivSpec2 = new IvParameterSpec(this.m_iv2);
        SecretKeySpec aesKey2 = this.m_aesKeys.length == 16 ? new SecretKeySpec(this.m_aesKeys, "AES") : new SecretKeySpec(this.m_aesKeys, 16, 16, "AES");
        try {
            this.m_aesEngine2.init(2, (Key)aesKey2, ivSpec2);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    public int encryptAES1(byte[] from, int ifrom, byte[] to, int ito, int len) {
        try {
            this.m_aesEngine1.update(from, ifrom, len, to, ito);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int encryptAES2(byte[] buff) {
        try {
            int len = buff.length;
            this.m_aesEngine2.update(buff, 0, len, buff, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] argv) {
        SymCipherCTR c = new SymCipherCTR();
        byte[] key = new byte[64];
        c.setEncryptionKeyAES(key);
        byte[] in = new byte[32];
        byte[] o1 = new byte[32];
        byte[] o2 = new byte[32];
        c.encryptAES1(in, 0, o1, 0, 17);
        c.encryptAES1(in, 17, o1, 17, 15);
        c.setEncryptionKeyAES(key);
        c.encryptAES1(in, 0, o2, 0, 32);
        c.encryptAES2(in);
        c.setEncryptionKeyAES(key);
        c.encryptAES1(o1, 0, in, 0, 17);
        c.encryptAES1(o1, 17, in, 17, 15);
        byte[] iv = new byte[16];
        for (int i = 0; i < 16; ++i) {
            iv[i] = -1;
        }
        c.setIV2(iv);
        byte[] o3 = new byte[17];
        byte[] o4 = new byte[17];
        c.encryptAES2(o3);
        c.encryptAES2(o4);
        int l = 3;
        ++l;
    }
}

