/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.forward.server.ForwardScheduler;
import anon.forward.server.IServerManager;
import anon.transport.connection.SocketConnection;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerSocketManager
implements Runnable,
IServerManager {
    private static final int MAXIMUM_CONNECTION_REQUESTS = 5;
    private ServerSocket m_serverSocket;
    private Thread m_managerThread;
    private ForwardScheduler m_parentScheduler;
    private int m_portNumber;

    public ServerSocketManager(int a_portNumber) {
        this.m_portNumber = a_portNumber;
    }

    public Object getId() {
        return this.getClass().getName() + "%" + Integer.toString(this.m_portNumber);
    }

    public void startServerManager(ForwardScheduler a_parentScheduler) throws Exception {
        this.m_serverSocket = new ServerSocket(this.m_portNumber, 5);
        this.m_serverSocket.setSoTimeout(0);
        this.m_parentScheduler = a_parentScheduler;
        this.m_managerThread = new Thread(this);
        this.m_managerThread.setDaemon(true);
        this.m_managerThread.start();
    }

    public void shutdown() {
        try {
            this.m_serverSocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_managerThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        boolean shutdown = false;
        while (!shutdown) {
            Socket newConnection = null;
            try {
                newConnection = this.m_serverSocket.accept();
            }
            catch (Exception e) {
                shutdown = true;
            }
            if (shutdown) continue;
            try {
                newConnection.setSoTimeout(200000);
                this.m_parentScheduler.handleNewConnection(new SocketConnection(newConnection));
            }
            catch (Exception exception) {}
        }
    }
}

