/*
 * Decompiled with CFR 0.152.
 */
package infoservice.japforwarding;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.util.XMLUtil;
import infoservice.Configuration;
import infoservice.japforwarding.ForwarderDBEntry;
import infoservice.japforwarding.ServerVerifier;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JapForwardingTools {
    private static final int FORWARDER_VERIFY_ERROR_CODE = 1;
    private static final String FORWARDER_VERIFY_ERROR_MESSAGE = "Could not verify the specified forwarder, maybe because of a connection timeout.";
    private static final int FORWARDER_RENEW_ERROR_CODE = 11;
    private static final String FORWARDER_RENEW_ERROR_MESSAGE = "No forwarder with the specified ID in the database, maybe the entry was removed because of inactivity.";
    private static final int FORWARDER_FETCH_ERROR_CODE = 21;
    private static final String FORWARDER_FETCH_ERROR_MESSAGE = "There are no forwarders available.";

    private static Vector getForwarderListInfoServices() {
        Enumeration enumer = Database.getInstance(InfoServiceDBEntry.class).getEntrySnapshotAsEnumeration();
        Vector<InfoServiceDBEntry> resultList = new Vector<InfoServiceDBEntry>();
        while (enumer.hasMoreElements()) {
            InfoServiceDBEntry currentInfoService = (InfoServiceDBEntry)enumer.nextElement();
            if (!currentInfoService.hasPrimaryForwarderList()) continue;
            resultList.addElement(currentInfoService);
        }
        return resultList;
    }

    public static String addForwarder(byte[] a_receivedData, InetAddress a_sourceAddress) {
        String answer = null;
        if (Configuration.getInstance().holdForwarderList()) {
            try {
                Document doc = XMLUtil.toXMLDocument(a_receivedData);
                NodeList japForwarderNodes = doc.getElementsByTagName("JapForwarder");
                if (japForwarderNodes.getLength() == 0) {
                    throw new Exception("Error in XML structure (JapForwarder node).");
                }
                Element japForwarderNode = (Element)japForwarderNodes.item(0);
                NodeList plainInformationNodes = japForwarderNode.getElementsByTagName("PlainInformation");
                if (plainInformationNodes.getLength() == 0) {
                    throw new Exception("Error in XML structure (PlainInformation node).");
                }
                Element plainInformationNode = (Element)plainInformationNodes.item(0);
                NodeList portNodes = plainInformationNode.getElementsByTagName("Port");
                if (portNodes.getLength() == 0) {
                    throw new Exception("Error in XML structure (Port node).");
                }
                Element portNode = (Element)portNodes.item(0);
                int portNumber = Integer.parseInt(portNode.getFirstChild().getNodeValue());
                Document answerDoc = XMLUtil.createDocument();
                Element answerJapForwarderNode = answerDoc.createElement("JapForwarder");
                ServerVerifier verifyInstance = new ServerVerifier(a_sourceAddress, portNumber);
                if (verifyInstance.verifyServer()) {
                    LogHolder.log(6, LogType.MISC, "JapForwardingTools: addForwarder: Added a new JAP forwarder to the forwarder database.");
                    ForwarderDBEntry newForwarder = new ForwarderDBEntry(a_sourceAddress, portNumber);
                    Database.getInstance(ForwarderDBEntry.class).update(newForwarder);
                    Element answerPlainInformationNode = answerDoc.createElement("PlainInformation");
                    Element answerForwarderNode = answerDoc.createElement("Forwarder");
                    answerForwarderNode.setAttribute("id", newForwarder.getId());
                    answerPlainInformationNode.appendChild(answerForwarderNode);
                    answerJapForwarderNode.appendChild(answerPlainInformationNode);
                } else {
                    LogHolder.log(7, LogType.MISC, "JapForwardingTools: addForwarder: Could not reach the forwarder. Entry not added.");
                    Element answerErrorInformationNode = answerDoc.createElement("ErrorInformation");
                    Element answerErrorNode = answerDoc.createElement("Error");
                    answerErrorNode.setAttribute("code", Integer.toString(1));
                    answerErrorNode.appendChild(answerDoc.createTextNode(FORWARDER_VERIFY_ERROR_MESSAGE));
                    answerErrorInformationNode.appendChild(answerErrorNode);
                    answerJapForwarderNode.appendChild(answerErrorInformationNode);
                }
                answerDoc.appendChild(answerJapForwarderNode);
                answer = XMLUtil.toString(answerDoc);
            }
            catch (Exception e) {
                LogHolder.log(7, LogType.MISC, "JapForwardingTools: addForwarder: Error while adding a forwarder: " + e.toString());
                answer = null;
            }
        }
        return answer;
    }

    public static String renewForwarder(byte[] a_receivedData) {
        String answer = null;
        if (Configuration.getInstance().holdForwarderList()) {
            try {
                Document doc = XMLUtil.toXMLDocument(a_receivedData);
                NodeList japForwarderNodes = doc.getElementsByTagName("JapForwarder");
                if (japForwarderNodes.getLength() == 0) {
                    throw new Exception("JapForwardingTools: renewForwarder: Error in XML structure (JapForwarder node).");
                }
                Element japForwarderNode = (Element)japForwarderNodes.item(0);
                NodeList plainInformationNodes = japForwarderNode.getElementsByTagName("PlainInformation");
                if (plainInformationNodes.getLength() == 0) {
                    throw new Exception("JapForwardingTools: renewForwarder: Error in XML structure (PlainInformation node).");
                }
                Element plainInformationNode = (Element)plainInformationNodes.item(0);
                NodeList forwarderNodes = plainInformationNode.getElementsByTagName("Forwarder");
                if (forwarderNodes.getLength() == 0) {
                    throw new Exception("JapForwardingTools: renewForwarder: Error in XML structure (Forwarder node).");
                }
                Element forwarderNode = (Element)forwarderNodes.item(0);
                String forwarderId = forwarderNode.getAttribute("id");
                Document answerDoc = XMLUtil.createDocument();
                Element answerJapForwarderNode = answerDoc.createElement("JapForwarder");
                ForwarderDBEntry forwarderEntry = (ForwarderDBEntry)Database.getInstance(ForwarderDBEntry.class).getEntryById(forwarderId);
                if (forwarderEntry != null) {
                    LogHolder.log(6, LogType.MISC, "JapForwardingTools: renewForwarder: Renewed a JAP forwarder in the forwarder database.");
                    Database.getInstance(ForwarderDBEntry.class).update(forwarderEntry.getUpdateClone());
                } else {
                    LogHolder.log(6, LogType.MISC, "JapForwardingTools: renewForwarder: Renew faild because of an unknown ID.");
                    Element answerErrorInformationNode = answerDoc.createElement("ErrorInformation");
                    Element answerErrorNode = answerDoc.createElement("Error");
                    answerErrorNode.setAttribute("code", Integer.toString(11));
                    answerErrorNode.appendChild(answerDoc.createTextNode(FORWARDER_RENEW_ERROR_MESSAGE));
                    answerErrorInformationNode.appendChild(answerErrorNode);
                    answerJapForwarderNode.appendChild(answerErrorInformationNode);
                }
                answerDoc.appendChild(answerJapForwarderNode);
                answer = XMLUtil.toString(answerDoc);
            }
            catch (Exception e) {
                LogHolder.log(7, LogType.MISC, "JapForwardingTools: renewForwarder: Error while renew: " + e.toString());
            }
        }
        return answer;
    }

    public static String getForwarder() {
        String answer = null;
        try {
            Document answerDoc = XMLUtil.createDocument();
            Node answerJapForwarderNode = answerDoc.createElement("JapForwarder");
            if (Configuration.getInstance().holdForwarderList()) {
                ForwarderDBEntry forwarderEntry = (ForwarderDBEntry)Database.getInstance(ForwarderDBEntry.class).getRandomEntry();
                if (forwarderEntry != null) {
                    answerJapForwarderNode = XMLUtil.importNode(answerDoc, forwarderEntry.createCaptchaNode(), true);
                    LogHolder.log(6, LogType.MISC, "JapForwardingTools: getForwarder: Returned one JAP forwarder entry from the own database.");
                } else {
                    LogHolder.log(6, LogType.MISC, "JapForwardingTools: getForwarder: Could not return a forwarder because database is empty.");
                    Element answerErrorInformationNode = answerDoc.createElement("ErrorInformation");
                    Element answerErrorNode = answerDoc.createElement("Error");
                    answerErrorNode.setAttribute("code", Integer.toString(21));
                    answerErrorNode.appendChild(answerDoc.createTextNode(FORWARDER_FETCH_ERROR_MESSAGE));
                    answerErrorInformationNode.appendChild(answerErrorNode);
                    answerJapForwarderNode.appendChild(answerErrorInformationNode);
                }
            } else {
                Enumeration enumer = JapForwardingTools.getForwarderListInfoServices().elements();
                boolean gotForwarder = false;
                while (enumer.hasMoreElements() && !gotForwarder) {
                    InfoServiceDBEntry currentInfoService = (InfoServiceDBEntry)enumer.nextElement();
                    try {
                        Element japForwarderNode = currentInfoService.getForwarder();
                        answerJapForwarderNode = XMLUtil.importNode(answerDoc, japForwarderNode, true);
                        if (answerJapForwarderNode == null) continue;
                        gotForwarder = true;
                        LogHolder.log(6, LogType.MISC, "JapForwardingTools: getForwarder: Returned one JAP forwarder fetched from a remote infoservice.");
                    }
                    catch (Exception japForwarderNode) {}
                }
                if (!gotForwarder) {
                    LogHolder.log(6, LogType.MISC, "JapForwardingTools: getForwarder: Could not return a forwarder because no known primary infoservice knows one.");
                    Element answerErrorInformationNode = answerDoc.createElement("ErrorInformation");
                    Element answerErrorNode = answerDoc.createElement("Error");
                    answerErrorNode.setAttribute("code", Integer.toString(21));
                    answerErrorNode.appendChild(answerDoc.createTextNode(FORWARDER_FETCH_ERROR_MESSAGE));
                    answerErrorInformationNode.appendChild(answerErrorNode);
                    answerJapForwarderNode.appendChild(answerErrorInformationNode);
                }
            }
            answerDoc.appendChild(answerJapForwarderNode);
            answer = XMLUtil.toString(answerDoc);
        }
        catch (Exception e) {
            LogHolder.log(7, LogType.MISC, "JapForwardingTools: getForwarder: Unexpected exception while getting entry: " + e.toString());
        }
        return answer;
    }
}

