/*
 * Decompiled with CFR 0.152.
 */
package infoservice.tor;

import anon.infoservice.Database;
import anon.tor.ordescription.ORDescriptor;
import anon.tor.ordescription.ORList;
import anon.util.ZLibTools;
import infoservice.tor.DummyORListFetcher;
import infoservice.tor.TorDirectoryServer;
import infoservice.tor.TorDirectoryServerUrl;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class TorDirectoryAgent
implements Runnable {
    private static final String DEFAULT_DIRECTORY_FILE = "/tor/server/all.z";
    private static TorDirectoryAgent ms_tdaInstance;
    private byte[] m_currentTorNodesList = null;
    private byte[] m_currentCompressedTorNodesList;
    private long m_updateInterval = -1L;

    public static TorDirectoryAgent getInstance() {
        if (ms_tdaInstance == null) {
            ms_tdaInstance = new TorDirectoryAgent();
        }
        return ms_tdaInstance;
    }

    private TorDirectoryAgent() {
    }

    public void addTorDirectoryServer(TorDirectoryServer a_torDirectoryServer) {
        Database.getInstance(TorDirectoryServer.class).update(a_torDirectoryServer);
        LogHolder.log(7, LogType.NET, "TorDirectoryAgent: addTorDirectoryServer: " + a_torDirectoryServer.getId() + " was updated or added to the list of known TOR directory servers.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpdateThread(long a_updateInterval) {
        TorDirectoryAgent torDirectoryAgent = this;
        synchronized (torDirectoryAgent) {
            if (this.m_updateInterval == -1L && a_updateInterval > 0L) {
                this.m_updateInterval = a_updateInterval;
                Thread fetchThread = new Thread((Runnable)this, "TorDirectoryAgent Update Thread");
                fetchThread.setDaemon(true);
                fetchThread.setPriority(1);
                fetchThread.start();
            }
        }
    }

    public byte[] getTorNodesList() {
        return this.m_currentTorNodesList;
    }

    public byte[] getCompressedTorNodesList() {
        return this.m_currentCompressedTorNodesList;
    }

    @Override
    public void run() {
        TorDirectoryServer preferedDirectoryServer = null;
        block8: while (true) {
            try {
                Vector torServers;
                while (true) {
                    LogHolder.log(6, LogType.NET, "TorDirectoryAgent: run: Try to fetch the tor nodes list from the known tor directory servers.");
                    Database db = Database.getInstance(TorDirectoryServer.class);
                    torServers = null;
                    if (db != null && (torServers = db.getEntryList()) != null) break;
                    LogHolder.log(7, LogType.NET, "TorDirectoryAgent: run: No TorDirectoryServer DB!");
                    try {
                        Thread.sleep(this.m_updateInterval);
                        continue block8;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
                if (preferedDirectoryServer != null) {
                    boolean preferedServerFound = false;
                    for (int i = 0; i < torServers.size() && !preferedServerFound; ++i) {
                        if (!((TorDirectoryServer)torServers.elementAt(i)).getId().equals(preferedDirectoryServer.getId())) continue;
                        torServers.removeElementAt(i);
                        preferedServerFound = true;
                    }
                    torServers.insertElementAt(preferedDirectoryServer, 0);
                }
                byte[] torNodesList = null;
                byte[] torNodesListCompressed = null;
                while (torNodesList == null && torServers.size() > 0) {
                    ORList torNodes;
                    TorDirectoryServer currentDirectoryServer = (TorDirectoryServer)torServers.firstElement();
                    byte[] torNodesCommpressedListInformation = currentDirectoryServer.downloadCompressedTorNodesInformation();
                    byte[] torNodesListInformation = null;
                    torServers.removeElementAt(0);
                    if (torNodesCommpressedListInformation != null) {
                        LogHolder.log(6, LogType.NET, "Start decommpressing the tor nodes list");
                        torNodesListInformation = ZLibTools.decompress(torNodesCommpressedListInformation);
                        LogHolder.log(6, LogType.NET, "Decommpressed the tor nodes list");
                    }
                    if (torNodesListInformation == null || !(torNodes = new ORList(new DummyORListFetcher(torNodesListInformation))).updateList()) continue;
                    Enumeration runningTorNodes = torNodes.getList().elements();
                    while (runningTorNodes.hasMoreElements()) {
                        ORDescriptor currentTorNode = (ORDescriptor)runningTorNodes.nextElement();
                        if (currentTorNode.getDirPort() <= 0) continue;
                        this.addTorDirectoryServer(new TorDirectoryServer(new TorDirectoryServerUrl(currentTorNode.getAddress(), currentTorNode.getDirPort(), DEFAULT_DIRECTORY_FILE), 3L * this.m_updateInterval / 2L, false));
                    }
                    try {
                        torNodesList = torNodesListInformation;
                        torNodesListCompressed = torNodesCommpressedListInformation;
                        if (preferedDirectoryServer != null) {
                            if (preferedDirectoryServer.getId().equals(currentDirectoryServer.getId())) continue;
                            preferedDirectoryServer = currentDirectoryServer;
                            LogHolder.log(6, LogType.NET, "TorDirectoryAgent: run: Prefered TOR directory server is now: " + preferedDirectoryServer.getId());
                            continue;
                        }
                        preferedDirectoryServer = currentDirectoryServer;
                        LogHolder.log(6, LogType.NET, "TorDirectoryAgent: run: Prefered TOR directory server is now: " + preferedDirectoryServer.getId());
                    }
                    catch (Exception e) {
                        LogHolder.log(3, LogType.MISC, "TorDirectoryAgent: run: Error while creating the XML structure with the TOR nodes list: " + e.toString());
                        torNodesList = null;
                    }
                }
                if (torNodesList == null) {
                    LogHolder.log(3, LogType.NET, "TorDirectoryAgent: run: Could not fetch the tor nodes list from the known tor directory servers.");
                    if (preferedDirectoryServer != null) {
                        preferedDirectoryServer = null;
                        LogHolder.log(6, LogType.NET, "TorDirectoryAgent: run: Prefered TOR directory server reset.");
                    }
                }
                if (torNodesList != null) {
                    LogHolder.log(7, LogType.NET, "TorDirectoryAgent: run: Fetched the list of tor nodes successfully.");
                }
                this.m_currentTorNodesList = torNodesList;
                this.m_currentCompressedTorNodesList = torNodesListCompressed;
            }
            catch (Throwable t) {
                LogHolder.log(3, LogType.NET, "TorDirectoryAgent: run: Exception!");
                LogHolder.log(3, LogType.NET, t);
            }
            try {
                Thread.sleep(this.m_updateInterval);
            }
            catch (Exception exception) {
            }
        }
    }
}

