/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Exception;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.BERTags;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DLApplicationSpecific;
import org.bouncycastle.asn1.DLExternal;
import org.bouncycastle.asn1.DLFactory;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;
import org.bouncycastle.asn1.LazyEncodedSequence;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.io.Streams;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private int limit;
    private boolean lazyEvaluate;
    private byte[][] tmpBuffers;

    public ASN1InputStream(InputStream is) {
        this(is, StreamUtil.findLimit(is));
    }

    public ASN1InputStream(byte[] input) {
        this((InputStream)new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(byte[] input, boolean lazyEvaluate) {
        this(new ByteArrayInputStream(input), input.length, lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit) {
        this(input, limit, false);
    }

    public ASN1InputStream(InputStream input, boolean lazyEvaluate) {
        this(input, StreamUtil.findLimit(input), lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit, boolean lazyEvaluate) {
        super(input);
        this.limit = limit;
        this.lazyEvaluate = lazyEvaluate;
        this.tmpBuffers = new byte[11][];
    }

    int getLimit() {
        return this.limit;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.readLength(this, this.limit, false);
    }

    protected void readFully(byte[] bytes) throws IOException {
        if (Streams.readFully(this, bytes) != bytes.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected ASN1Primitive buildObject(int tag, int tagNo, int length) throws IOException {
        boolean isConstructed = (tag & 0x20) != 0;
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this, length, this.limit);
        if ((tag & 0x40) != 0) {
            return new DLApplicationSpecific(isConstructed, tagNo, defIn.toByteArray());
        }
        if ((tag & 0x80) != 0) {
            return new ASN1StreamParser(defIn).readTaggedObject(isConstructed, tagNo);
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    ASN1EncodableVector v = this.readVector(defIn);
                    ASN1OctetString[] strings = new ASN1OctetString[v.size()];
                    for (int i = 0; i != strings.length; ++i) {
                        ASN1Encodable asn1Obj = v.get(i);
                        if (!(asn1Obj instanceof ASN1OctetString)) {
                            throw new ASN1Exception("unknown object encountered in constructed OCTET STRING: " + asn1Obj.getClass());
                        }
                        strings[i] = (ASN1OctetString)asn1Obj;
                    }
                    return new BEROctetString(strings);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new LazyEncodedSequence(defIn.toByteArray());
                    }
                    return DLFactory.createSequence(this.readVector(defIn));
                }
                case 17: {
                    return DLFactory.createSet(this.readVector(defIn));
                }
                case 8: {
                    return new DLExternal(this.readVector(defIn));
                }
            }
            throw new IOException("unknown tag " + tagNo + " encountered");
        }
        return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn, this.tmpBuffers);
    }

    ASN1EncodableVector readVector(DefiniteLengthInputStream dIn) throws IOException {
        ASN1Primitive p;
        if (dIn.getRemaining() < 1) {
            return new ASN1EncodableVector(0);
        }
        ASN1InputStream subStream = new ASN1InputStream(dIn);
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((p = subStream.readObject()) != null) {
            v.add(p);
        }
        return v;
    }

    public ASN1Primitive readObject() throws IOException {
        int tag = this.read();
        if (tag <= 0) {
            if (tag == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int tagNo = ASN1InputStream.readTagNumber(this, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = this.readLength();
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this, this.limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this.limit);
            if ((tag & 0x40) != 0) {
                return new BERApplicationSpecificParser(tagNo, sp).getLoadedObject();
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(true, tagNo, sp).getLoadedObject();
            }
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(sp).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(sp).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(sp).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(sp).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(tag, tagNo, length);
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception("corrupted stream detected", e);
        }
    }

    static int readTagNumber(InputStream s, int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b = s.read();
            if ((b & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = s.read();
            }
            if (b < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    static int readLength(InputStream s, int limit, boolean isParsing) throws IOException {
        int length = s.read();
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes: " + size);
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = s.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= limit && !isParsing) {
                throw new IOException("corrupted stream - out of bounds length found: " + length + " >= " + limit);
            }
        }
        return length;
    }

    private static byte[] getBuffer(DefiniteLengthInputStream defIn, byte[][] tmpBuffers) throws IOException {
        int len = defIn.getRemaining();
        if (len >= tmpBuffers.length) {
            return defIn.toByteArray();
        }
        byte[] buf = tmpBuffers[len];
        if (buf == null) {
            tmpBuffers[len] = new byte[len];
            buf = tmpBuffers[len];
        }
        defIn.readAllIntoByteArray(buf);
        return buf;
    }

    private static char[] getBMPCharBuffer(DefiniteLengthInputStream defIn) throws IOException {
        int remainingBytes = defIn.getRemaining();
        if (0 != (remainingBytes & 1)) {
            throw new IOException("malformed BMPString encoding encountered");
        }
        char[] string = new char[remainingBytes / 2];
        int stringPos = 0;
        byte[] buf = new byte[8];
        while (remainingBytes >= 8) {
            if (Streams.readFully(defIn, buf, 0, 8) != 8) {
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            string[stringPos] = (char)(buf[0] << 8 | buf[1] & 0xFF);
            string[stringPos + 1] = (char)(buf[2] << 8 | buf[3] & 0xFF);
            string[stringPos + 2] = (char)(buf[4] << 8 | buf[5] & 0xFF);
            string[stringPos + 3] = (char)(buf[6] << 8 | buf[7] & 0xFF);
            stringPos += 4;
            remainingBytes -= 8;
        }
        if (remainingBytes > 0) {
            if (Streams.readFully(defIn, buf, 0, remainingBytes) != remainingBytes) {
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            int bufPos = 0;
            do {
                int b1 = buf[bufPos++] << 8;
                int b2 = buf[bufPos++] & 0xFF;
                string[stringPos++] = (char)(b1 | b2);
            } while (bufPos < remainingBytes);
        }
        if (0 != defIn.getRemaining() || string.length != stringPos) {
            throw new IllegalStateException();
        }
        return string;
    }

    static ASN1Primitive createPrimitiveDERObject(int tagNo, DefiniteLengthInputStream defIn, byte[][] tmpBuffers) throws IOException {
        switch (tagNo) {
            case 3: {
                return ASN1BitString.fromInputStream(defIn.getRemaining(), defIn);
            }
            case 30: {
                return new DERBMPString(ASN1InputStream.getBMPCharBuffer(defIn));
            }
            case 1: {
                return ASN1Boolean.fromOctetString(ASN1InputStream.getBuffer(defIn, tmpBuffers));
            }
            case 10: {
                return ASN1Enumerated.fromOctetString(ASN1InputStream.getBuffer(defIn, tmpBuffers));
            }
            case 24: {
                return new ASN1GeneralizedTime(defIn.toByteArray());
            }
            case 27: {
                return new DERGeneralString(defIn.toByteArray());
            }
            case 22: {
                return new DERIA5String(defIn.toByteArray());
            }
            case 2: {
                return new ASN1Integer(defIn.toByteArray(), false);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(defIn.toByteArray());
            }
            case 6: {
                return ASN1ObjectIdentifier.fromOctetString(ASN1InputStream.getBuffer(defIn, tmpBuffers));
            }
            case 4: {
                return new DEROctetString(defIn.toByteArray());
            }
            case 19: {
                return new DERPrintableString(defIn.toByteArray());
            }
            case 20: {
                return new DERT61String(defIn.toByteArray());
            }
            case 28: {
                return new DERUniversalString(defIn.toByteArray());
            }
            case 23: {
                return new ASN1UTCTime(defIn.toByteArray());
            }
            case 12: {
                return new DERUTF8String(defIn.toByteArray());
            }
            case 26: {
                return new DERVisibleString(defIn.toByteArray());
            }
            case 25: {
                return new DERGraphicString(defIn.toByteArray());
            }
            case 21: {
                return new DERVideotexString(defIn.toByteArray());
            }
        }
        throw new IOException("unknown tag " + tagNo + " encountered");
    }
}

