/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPublicKey;
import anon.crypto.MyDSAPublicKey;
import anon.crypto.MyRSAPublicKey;
import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.math.BigInteger;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLJapPublicKey
implements IXMLEncodable {
    private IMyPublicKey m_publicKey;
    private static String ms_elemName = "JapPublicKey";

    public static String getXMLElementName() {
        return ms_elemName;
    }

    public XMLJapPublicKey(IMyPublicKey key) {
        this.m_publicKey = key;
    }

    public XMLJapPublicKey(byte[] data) throws Exception {
        Document doc = XMLUtil.toXMLDocument(data);
        this.setPubKey(doc.getDocumentElement());
    }

    public XMLJapPublicKey(char[] data) throws Exception {
        this(new String(data));
    }

    public XMLJapPublicKey(String data) throws XMLParseException {
        Document doc = XMLUtil.toXMLDocument(data);
        this.setPubKey(doc.getDocumentElement());
    }

    public XMLJapPublicKey(Element elemKey) throws XMLParseException {
        this.setPubKey(elemKey);
    }

    public IMyPublicKey getPublicKey() {
        return this.m_publicKey;
    }

    private void setPubKey(Element elemKey) throws XMLParseException {
        if (!elemKey.getTagName().equals(ms_elemName)) {
            throw new XMLParseException("XMLJapPublicKey wrong xml structure. Tagname is" + elemKey.getTagName());
        }
        Element elemRsa = (Element)XMLUtil.getFirstChildByName(elemKey, "RSAKeyValue");
        if (elemRsa != null) {
            Element elemMod = (Element)XMLUtil.getFirstChildByName(elemRsa, "Modulus");
            Element elemExp = (Element)XMLUtil.getFirstChildByName(elemRsa, "Exponent");
            BigInteger modulus = new BigInteger(Base64.decode(XMLUtil.parseValue((Node)elemMod, "")));
            BigInteger exponent = new BigInteger(Base64.decode(XMLUtil.parseValue((Node)elemExp, "")));
            this.m_publicKey = new MyRSAPublicKey(modulus, exponent);
            return;
        }
        Element elemDsa = (Element)XMLUtil.getFirstChildByName(elemKey, "DSAKeyValue");
        if (elemDsa != null) {
            Element elem = (Element)XMLUtil.getFirstChildByName(elemDsa, "P");
            BigInteger p = new BigInteger(Base64.decode(XMLUtil.parseValue((Node)elem, "")));
            elem = (Element)XMLUtil.getFirstChildByName(elemDsa, "Y");
            BigInteger y = new BigInteger(Base64.decode(XMLUtil.parseValue((Node)elem, "")));
            elem = (Element)XMLUtil.getFirstChildByName(elemDsa, "Q");
            BigInteger q = new BigInteger(Base64.decode(XMLUtil.parseValue((Node)elem, "")));
            elem = (Element)XMLUtil.getFirstChildByName(elemDsa, "G");
            BigInteger g = new BigInteger(Base64.decode(XMLUtil.parseValue((Node)elem, "")));
            DSAPublicKeyParameters param = new DSAPublicKeyParameters(y, new DSAParameters(p, q, g));
            this.m_publicKey = new MyDSAPublicKey(param);
            return;
        }
        throw new XMLParseException("Wrong key format: Neither RSAKeyValue nor DSAKeyValue found!");
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(ms_elemName);
        elemRoot.setAttribute("version", "1.0");
        Element elem = this.m_publicKey.toXmlElement(a_doc);
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    public boolean equals(XMLJapPublicKey k) {
        if (k == null) {
            return false;
        }
        IMyPublicKey k1 = k.getPublicKey();
        IMyPublicKey k2 = this.getPublicKey();
        if (k1 == null) {
            return k2 == null;
        }
        if (k1 instanceof MyRSAPublicKey && !(k2 instanceof MyRSAPublicKey)) {
            return false;
        }
        if (k1 instanceof MyDSAPublicKey && !(k2 instanceof MyDSAPublicKey)) {
            return false;
        }
        return k1.equals(k2);
    }
}

