/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.tor.cells.Cell;

final class CellQueue {
    private CellQueueEntry m_firstEntry = null;
    private CellQueueEntry m_lastEntry = null;
    private int m_iSize = 0;

    public synchronized void addElement(Cell c) {
        CellQueueEntry entry = new CellQueueEntry(c);
        if (this.m_lastEntry == null) {
            this.m_firstEntry = this.m_lastEntry = entry;
        } else {
            this.m_lastEntry.m_next = entry;
            this.m_lastEntry = entry;
        }
        ++this.m_iSize;
    }

    public synchronized Cell removeElement() {
        if (this.m_firstEntry == null) {
            return null;
        }
        Cell c = this.m_firstEntry.m_Cell;
        this.m_firstEntry = this.m_firstEntry.m_next;
        if (this.m_firstEntry == null) {
            this.m_lastEntry = null;
        }
        --this.m_iSize;
        return c;
    }

    public synchronized int size() {
        return this.m_iSize;
    }

    public synchronized boolean isEmpty() {
        return this.m_firstEntry == null;
    }

    final class CellQueueEntry {
        Cell m_Cell;
        CellQueueEntry m_next;

        CellQueueEntry(Cell c) {
            this.m_Cell = c;
            this.m_next = null;
        }
    }
}

