/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.ServiceLocation;
import anon.infoservice.ServiceOperator;
import anon.util.CountryMapper;
import anon.util.JAPMessages;
import gui.GUIUtils;
import jap.JAPModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public final class ServerListPanel
extends JPanel
implements ActionListener {
    private static final String MSG_MIX_CLICK = (class$jap$ServerListPanel == null ? (class$jap$ServerListPanel = ServerListPanel.class$("jap.ServerListPanel")) : class$jap$ServerListPanel).getName() + "_mixClick";
    private static final String MSG_MIX_COUNTRY = (class$jap$ServerListPanel == null ? (class$jap$ServerListPanel = ServerListPanel.class$("jap.ServerListPanel")) : class$jap$ServerListPanel).getName() + "_mixCountry";
    private static final String MSG_OPERATOR_COUNTRY = (class$jap$ServerListPanel == null ? (class$jap$ServerListPanel = ServerListPanel.class$("jap.ServerListPanel")) : class$jap$ServerListPanel).getName() + "_operatorCountry";
    private static final String MSG_MIX_AND_OPERATOR_COUNTRY = (class$jap$ServerListPanel == null ? (class$jap$ServerListPanel = ServerListPanel.class$("jap.ServerListPanel")) : class$jap$ServerListPanel).getName() + "_mixAndOperatorCountry";
    private boolean m_bEnabled;
    private ButtonGroup m_bgMixe;
    private int m_selectedIndex;
    private Vector m_itemListeners;
    private JRadioButton[] m_mixButtons;
    private JLabel[] m_mixFlags;
    private JLabel[] m_operatorFlags;
    static /* synthetic */ Class class$jap$ServerListPanel;

    public ServerListPanel(int a_numberOfMixes, boolean a_enabled, int a_selectedIndex) {
        int selectedIndex = 0;
        if (a_numberOfMixes < 1) {
            a_numberOfMixes = 1;
        }
        if (a_selectedIndex > 0 && a_selectedIndex < a_numberOfMixes) {
            selectedIndex = a_selectedIndex;
        }
        this.m_mixButtons = new JRadioButton[a_numberOfMixes];
        this.m_mixFlags = new JLabel[a_numberOfMixes];
        this.m_operatorFlags = new JLabel[a_numberOfMixes];
        this.m_itemListeners = new Vector();
        GridBagLayout la = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_bgMixe = new ButtonGroup();
        this.m_selectedIndex = 0;
        this.setLayout(la);
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.fill = 2;
        for (int i = 0; i < a_numberOfMixes; ++i) {
            constraints.gridy = 0;
            constraints.gridx = i * 2;
            constraints.gridheight = 3;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.m_mixButtons[i] = new JRadioButton();
            if (a_enabled) {
                this.m_mixButtons[i].setToolTipText(JAPMessages.getString("serverPanelAdditional"));
            }
            this.m_mixButtons[i].addActionListener(this);
            this.m_mixButtons[i].setBorder(null);
            this.m_mixButtons[i].setFocusPainted(false);
            this.m_mixButtons[i].setRolloverEnabled(true);
            this.m_mixButtons[i].setIcon(GUIUtils.loadImageIcon("server.gif", true));
            this.m_mixButtons[i].setRolloverIcon(GUIUtils.loadImageIcon("server_blau.gif", true));
            this.m_mixButtons[i].setSelectedIcon(GUIUtils.loadImageIcon("server_rot.gif", true));
            this.m_mixButtons[i].setCursor(Cursor.getPredefinedCursor(12));
            if (i == selectedIndex) {
                this.m_selectedIndex = i;
                this.m_mixButtons[i].setSelected(true);
            }
            this.add((Component)this.m_mixButtons[i], constraints);
            this.m_bgMixe.add(this.m_mixButtons[i]);
            this.m_bEnabled = a_enabled;
            this.m_mixButtons[i].setEnabled(this.m_bEnabled);
            constraints.gridy = 0;
            constraints.gridheight = 1;
            constraints.gridx = i * 2 + 1;
            constraints.weightx = 0.0;
            this.m_mixFlags[i] = new JLabel(" ");
            this.m_mixFlags[i].setFont(new Font("", 0, (int)(14.0 * (1.0 + (double)JAPModel.getInstance().getFontSize() * 0.1))));
            this.add((Component)this.m_mixFlags[i], constraints);
            constraints.gridx = i * 2 + 1;
            constraints.gridheight = 1;
            constraints.gridy = 1;
            constraints.weightx = a_numberOfMixes == 1 ? 0.5 : 0.5 / (double)(a_numberOfMixes - 1);
            JSeparator sep = new JSeparator();
            this.add((Component)sep, constraints);
            constraints.gridy = 2;
            constraints.gridheight = 1;
            constraints.gridx = i * 2 + 1;
            constraints.weightx = 0.0;
            this.m_operatorFlags[i] = new JLabel("");
            this.m_operatorFlags[i].setFont(new Font("", 0, (int)(10.0 * (1.0 + (double)JAPModel.getInstance().getFontSize() * 0.1))));
            JPanel pnlDummy = new JPanel(new GridBagLayout());
            GridBagConstraints dummyConstraints = new GridBagConstraints();
            dummyConstraints.gridx = 0;
            dummyConstraints.gridy = 0;
            dummyConstraints.fill = 0;
            dummyConstraints.anchor = 17;
            pnlDummy.add((Component)this.m_operatorFlags[i], dummyConstraints);
            dummyConstraints.weightx = 1.0;
            dummyConstraints.gridx = 1;
            dummyConstraints.fill = 2;
            pnlDummy.add((Component)new JLabel(), dummyConstraints);
            this.add((Component)pnlDummy, constraints);
        }
        ++constraints.gridx;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.gridheight = 3;
        constraints.fill = 2;
        constraints.anchor = 13;
        ImageIcon icon = GUIUtils.loadImageIcon("cloud.png", true);
        this.add((Component)new JLabel(icon), constraints);
        ++constraints.gridx;
        constraints.weightx = 0.7;
        this.add((Component)new JLabel(""), constraints);
    }

    public boolean areMixButtonsEnabled() {
        return this.m_bEnabled;
    }

    public int getNumberOfMixes() {
        return this.m_mixButtons.length;
    }

    public synchronized void moveToPrevious() {
        JRadioButton btn = this.setSelectedIndex(this.m_selectedIndex - 1);
        if (btn != null) {
            this.actionPerformed(new ActionEvent(btn, 1001, null));
        }
    }

    public synchronized void moveToNext() {
        JRadioButton btn = this.setSelectedIndex(this.m_selectedIndex + 1);
        if (btn != null) {
            this.actionPerformed(new ActionEvent(btn, 1001, null));
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Enumeration<AbstractButton> mixes = this.m_bgMixe.getElements();
        int index = 0;
        while (mixes.hasMoreElements()) {
            if (source == mixes.nextElement()) {
                this.m_selectedIndex = index;
                ItemEvent itemEvent = new ItemEvent((AbstractButton)source, 701, source, 1);
                Enumeration enumer = this.m_itemListeners.elements();
                while (enumer.hasMoreElements()) {
                    ((ItemListener)enumer.nextElement()).itemStateChanged(itemEvent);
                }
                return;
            }
            ++index;
        }
    }

    public void addItemListener(ItemListener l) {
        this.m_itemListeners.addElement(l);
    }

    public void removeItemListener(ItemListener a_listener) {
        this.m_itemListeners.removeElement(a_listener);
    }

    public synchronized JRadioButton setSelectedIndex(int a_index) {
        int i;
        if (a_index < 0) {
            return null;
        }
        Enumeration<AbstractButton> mixes = this.m_bgMixe.getElements();
        for (i = 0; i < a_index && mixes.hasMoreElements(); ++i) {
            mixes.nextElement();
        }
        if (!mixes.hasMoreElements()) {
            return null;
        }
        this.m_selectedIndex = i;
        JRadioButton btnAffected = (JRadioButton)mixes.nextElement();
        btnAffected.setSelected(true);
        return btnAffected;
    }

    private synchronized void updateFlag(int a_mix, ServiceLocation a_location) {
        if (a_location != null) {
            try {
                CountryMapper county = new CountryMapper(a_location.getCountryCode(), JAPMessages.getLocale());
                this.m_mixFlags[a_mix].setIcon(GUIUtils.loadImageIcon("flags/" + county.getISOCode() + ".png"));
                this.m_mixFlags[a_mix].setToolTipText(JAPMessages.getString(MSG_MIX_COUNTRY, county.toString()));
            }
            catch (IllegalArgumentException a_e) {
                this.m_mixFlags[a_mix].setIcon(null);
                this.m_mixFlags[a_mix].setToolTipText(null);
            }
        } else {
            this.m_mixFlags[a_mix].setIcon(null);
            this.m_mixFlags[a_mix].setToolTipText(null);
        }
    }

    public synchronized void update(int a_mix, ServiceOperator a_operator, ServiceLocation a_location) {
        if (a_operator != null && a_operator.getCountryCode() != null) {
            if (a_location != null && a_location.getCountryCode() != null && !a_location.getCountryCode().equals(a_operator.getCountryCode())) {
                this.updateFlag(a_mix, a_location);
                this.updateOperatorFlag(a_mix, a_operator, false);
            } else {
                this.updateOperatorFlag(a_mix, a_operator, true);
            }
            if (a_operator.getCertPath().isVerified()) {
                if (!a_operator.getCertPath().isValid(new Date())) {
                    this.m_operatorFlags[a_mix].setBorder(BorderFactory.createLineBorder(Color.yellow, 2));
                } else if (a_operator.getCertPath().countVerifiedAndValidPaths() > 2) {
                    this.m_operatorFlags[a_mix].setBorder(BorderFactory.createLineBorder(Color.green, 2));
                } else if (a_operator.getCertPath().countVerifiedAndValidPaths() > 1) {
                    this.m_operatorFlags[a_mix].setBorder(BorderFactory.createLineBorder(new Color(100, 215, 255), 2));
                } else {
                    this.m_operatorFlags[a_mix].setBorder(BorderFactory.createEmptyBorder());
                }
            } else {
                this.m_operatorFlags[a_mix].setBorder(BorderFactory.createLineBorder(Color.red, 2));
            }
        } else {
            this.updateOperatorFlag(a_mix, a_operator, false);
            this.updateFlag(a_mix, a_location);
        }
    }

    private synchronized void updateOperatorFlag(int a_mix, ServiceOperator a_operator, boolean a_mixAndOperator) {
        if (a_operator != null && a_operator.getCountryCode() != null) {
            CountryMapper county = new CountryMapper(a_operator.getCountryCode(), JAPMessages.getLocale());
            this.m_operatorFlags[a_mix].setIcon(GUIUtils.loadImageIcon("flags/" + county.getISOCode() + ".png"));
            if (a_mixAndOperator) {
                this.m_operatorFlags[a_mix].setToolTipText(JAPMessages.getString(MSG_MIX_AND_OPERATOR_COUNTRY, county.toString()));
                this.updateFlag(a_mix, null);
            } else {
                this.m_operatorFlags[a_mix].setToolTipText(JAPMessages.getString(MSG_OPERATOR_COUNTRY, county.toString()));
            }
        } else {
            this.m_operatorFlags[a_mix].setIcon(null);
            this.m_operatorFlags[a_mix].setToolTipText(null);
        }
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

