/*
 * Decompiled with CFR 0.152.
 */
package logging;

import logging.AbstractLog;
import logging.LogType;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractLog4jLog
extends AbstractLog {
    protected abstract Logger getLogger();

    public AbstractLog4jLog() {
        this.setLogType(LogType.ALL);
        this.setLogLevel(7);
    }

    public void log(int a_level, int a_type, String a_message) {
        if (!this.isLogged(a_level, a_type)) {
            return;
        }
        Level log4jPriority = Level.DEBUG;
        if (a_level == 7) {
            log4jPriority = Level.DEBUG;
        } else if (a_level == 6 || a_level == 5) {
            log4jPriority = Level.INFO;
        } else if (a_level == 4) {
            log4jPriority = Level.WARN;
        } else if (a_level == 3 || a_level == 2) {
            log4jPriority = Level.ERROR;
        } else if (a_level == 1 || a_level == 0) {
            log4jPriority = Level.FATAL;
        }
        this.getLogger().log(null, log4jPriority, a_message, null);
    }

    public synchronized void setLogLevel(int level) {
        super.setLogLevel(level);
        Level l = Level.ALL;
        switch (level) {
            case 7: {
                l = Level.DEBUG;
                break;
            }
            case 5: 
            case 6: {
                l = Level.INFO;
                break;
            }
            case 0: 
            case 1: {
                l = Level.FATAL;
                break;
            }
            case 4: {
                l = Level.WARN;
                break;
            }
            case 2: 
            case 3: {
                l = Level.ERROR;
            }
        }
        this.getLogger().setLevel(l);
    }

    public synchronized int getLogLevel() {
        int level = super.getLogLevel();
        if (this.getLogger().isEnabledFor(Level.DEBUG)) {
            level = 7;
        } else if (this.getLogger().isEnabledFor(Level.INFO)) {
            if (level != 5) {
                level = 6;
            }
        } else if (this.getLogger().isEnabledFor(Level.WARN)) {
            level = 4;
        } else if (this.getLogger().isEnabledFor(Level.ERROR)) {
            if (level != 2) {
                level = 3;
            }
        } else if (this.getLogger().isEnabledFor(Level.FATAL) && level != 0) {
            level = 1;
        }
        super.setLogLevel(level);
        return level;
    }
}

