/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.ByteSignature;
import anon.crypto.CertificationRequestInfo;
import anon.crypto.IMyPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

final class CertificationRequest
extends DERSequence {
    private CertificationRequestInfo m_certificationRequestInfo;
    private DERBitString m_signature;

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair) {
        super((DEREncodableVector)CertificationRequest.createRequest(certificationRequestInfo, asymmetricCryptoKeyPair.getPrivate().getSignatureAlgorithm().getIdentifier(), new DERBitString(ByteSignature.sign(CertificationRequest.DERtoBytes((Object)certificationRequestInfo), asymmetricCryptoKeyPair))));
        this.m_certificationRequestInfo = certificationRequestInfo;
        this.m_signature = new DERBitString(ByteSignature.sign(CertificationRequest.DERtoBytes((Object)certificationRequestInfo), asymmetricCryptoKeyPair));
    }

    CertificationRequest(ASN1Sequence aSN1Sequence) {
        super((DEREncodableVector)CertificationRequest.createRequest((DERSequence)aSN1Sequence.getObjectAt(0), AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(1)), (DERBitString)aSN1Sequence.getObjectAt(2)));
        this.m_certificationRequestInfo = new CertificationRequestInfo((ASN1Sequence)((DERSequence)aSN1Sequence.getObjectAt(0)));
        this.m_signature = (DERBitString)aSN1Sequence.getObjectAt(2);
    }

    public IMyPublicKey getPublicKey() {
        return this.m_certificationRequestInfo.getPublicKey();
    }

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.m_certificationRequestInfo;
    }

    public boolean verify() {
        return ByteSignature.verify(CertificationRequest.DERtoBytes((Object)this.m_certificationRequestInfo), this.m_signature.getBytes(), this.getPublicKey());
    }

    private static ASN1EncodableVector createRequest(DERSequence dERSequence, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)dERSequence);
        aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
        aSN1EncodableVector.add((DEREncodable)dERBitString);
        return aSN1EncodableVector;
    }

    private static byte[] DERtoBytes(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not write DER data to bytes.");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

