/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.ICertificate;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.PKCS10CertificationRequest;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509Extensions;
import anon.util.Base64;
import anon.util.IMiscPasswordReader;
import anon.util.ResourceLoader;
import anon.util.SingleStringPasswordReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public final class PKCS12
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
ICertificate {
    public static final String FILE_EXTENSION = ".pfx";
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 100;
    private static final String BASE64_TAG = "PKCS12";
    public static final String XML_ELEMENT_NAME = "X509PKCS12";
    private static final String KEY_ALGORITHM = "1.2.840.113549.1.12.1.3";
    private static final String CERT_ALGORITHM = "1.2.840.113549.1.12.1.6";
    private SecureRandom random = new SecureRandom();
    private AsymmetricCryptoKeyPair m_keyPair;
    private JAPCertificate m_x509certificate;

    public PKCS12(X509DistinguishedName x509DistinguishedName, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair, Validity validity) {
        this(x509DistinguishedName, asymmetricCryptoKeyPair, validity, null);
    }

    public PKCS12(X509DistinguishedName x509DistinguishedName, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair, Validity validity, X509Extensions x509Extensions) {
        this.m_keyPair = asymmetricCryptoKeyPair;
        this.m_x509certificate = JAPCertificate.getInstance(x509DistinguishedName, asymmetricCryptoKeyPair, validity, x509Extensions);
    }

    private PKCS12(AsymmetricCryptoKeyPair asymmetricCryptoKeyPair, JAPCertificate jAPCertificate) {
        this.m_keyPair = asymmetricCryptoKeyPair;
        this.m_x509certificate = jAPCertificate;
    }

    public static PKCS12 getInstance(byte[] byArray, char[] cArray) {
        return PKCS12.getInstance(byArray, (IMiscPasswordReader)new SingleStringPasswordReader(cArray));
    }

    public static PKCS12 getInstance(byte[] byArray, String string) {
        return PKCS12.getInstance(byArray, (IMiscPasswordReader)new SingleStringPasswordReader(string));
    }

    public static PKCS12 getInstance(String string, String string2) {
        return PKCS12.getInstance(string.getBytes(), string2.toCharArray());
    }

    public static PKCS12 getInstance(byte[] byArray, IMiscPasswordReader iMiscPasswordReader) {
        if (byArray == null) {
            return null;
        }
        return PKCS12.getInstance((InputStream)new ByteArrayInputStream(byArray), iMiscPasswordReader);
    }

    public static PKCS12 getInstance(InputStream inputStream, char[] cArray) {
        return PKCS12.getInstance(inputStream, (IMiscPasswordReader)new SingleStringPasswordReader(cArray));
    }

    public static PKCS12 getInstance(InputStream inputStream, String string) {
        return PKCS12.getInstance(inputStream, (IMiscPasswordReader)new SingleStringPasswordReader(string));
    }

    public static PKCS12 getInstance(InputStream inputStream, IMiscPasswordReader iMiscPasswordReader) {
        boolean bl = false;
        char[] cArray = new char[]{};
        if (iMiscPasswordReader == null) {
            iMiscPasswordReader = new SingleStringPasswordReader(new char[0]);
        }
        try {
            String string = null;
            IMyPrivateKey iMyPrivateKey = null;
            X509CertificateStructure x509CertificateStructure = null;
            ASN1Sequence aSN1Sequence = JAPCertificate.toASN1Sequence(ResourceLoader.getStreamAsBytes(inputStream), XML_ELEMENT_NAME);
            if (aSN1Sequence == null) {
                return null;
            }
            ContentInfo contentInfo = new Pfx(aSN1Sequence).getAuthSafe();
            if (!contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.data)) {
                return null;
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((ASN1OctetString)contentInfo.getContent()).getOctets()));
            ContentInfo[] contentInfoArray = new AuthenticatedSafe((ASN1Sequence)aSN1InputStream.readObject()).getContentInfo();
            for (int i = 0; i < contentInfoArray.length; ++i) {
                FilterInputStream filterInputStream;
                Object object;
                Object object2;
                String string2;
                ASN1Sequence aSN1Sequence2;
                ASN1InputStream aSN1InputStream2;
                if (contentInfoArray[i].getContentType().equals((Object)PKCSObjectIdentifiers.data)) {
                    aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)contentInfoArray[i].getContent()).getOctets()));
                    aSN1Sequence2 = (ASN1Sequence)aSN1InputStream2.readObject();
                } else {
                    if (!contentInfoArray[i].getContentType().equals((Object)PKCSObjectIdentifiers.encryptedData)) continue;
                    aSN1InputStream2 = new EncryptedData((ASN1Sequence)contentInfoArray[i].getContent());
                    string2 = aSN1InputStream2.getEncryptionAlgorithm().getObjectId().getId();
                    object2 = PKCS12.getCipher(string2);
                    if (object2 == null) {
                        return null;
                    }
                    object = new PKCS12PBEParams((ASN1Sequence)aSN1InputStream2.getEncryptionAlgorithm().getParameters());
                    filterInputStream = null;
                    do {
                        try {
                            filterInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(PKCS12.codeData(false, aSN1InputStream2.getContent().getOctets(), object, cArray, ((MyCipher)object2).cipher, ((MyCipher)object2).keysize)));
                            aSN1Sequence2 = (ASN1Sequence)filterInputStream.readObject();
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            aSN1Sequence2 = null;
                            filterInputStream.close();
                            cArray = cArray.length == 0 ? new char[]{'\u0000'} : iMiscPasswordReader.readPassword(null).toCharArray();
                        }
                    } while (!bl);
                }
                for (int j = 0; j < aSN1Sequence2.size(); ++j) {
                    DERObject dERObject;
                    ASN1InputStream aSN1InputStream3;
                    string2 = new SafeBag((ASN1Sequence)aSN1Sequence2.getObjectAt(j));
                    if (string2.getBagId().equals((Object)PKCSObjectIdentifiers.certBag)) {
                        aSN1InputStream3 = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)new CertBag((ASN1Sequence)string2.getBagValue()).getCertValue()).getOctets()));
                        object2 = (ASN1Sequence)aSN1InputStream3.readObject();
                        x509CertificateStructure = object2.size() > 1 && object2.getObjectAt(1) instanceof DERObjectIdentifier && object2.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData) ? X509CertificateStructure.getInstance((Object)new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)object2.getObjectAt(1)), (boolean)true)).getCertificates().getObjectAt(0)) : X509CertificateStructure.getInstance((Object)object2);
                    } else if (string2.getBagId().equals((Object)PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                        object2 = new EncryptedPrivateKeyInfo((ASN1Sequence)string2.getBagValue());
                        object = PKCS12.getCipher(object2.getEncryptionAlgorithm().getObjectId().getId());
                        if (object == null) {
                            return null;
                        }
                        filterInputStream = new PKCS12PBEParams((ASN1Sequence)object2.getEncryptionAlgorithm().getParameters());
                        do {
                            aSN1InputStream3 = null;
                            try {
                                aSN1InputStream3 = new ASN1InputStream((InputStream)new ByteArrayInputStream(PKCS12.codeData(false, object2.getEncryptedData(), (PKCS12PBEParams)filterInputStream, cArray, object.cipher, object.keysize)));
                                dERObject = new PrivateKeyInfo((ASN1Sequence)aSN1InputStream3.readObject());
                                bl = true;
                            }
                            catch (Throwable throwable) {
                                dERObject = null;
                                aSN1InputStream3.close();
                                if (cArray.length == 0) {
                                    cArray = new char[]{'\u0000'};
                                    continue;
                                }
                                while ((cArray = iMiscPasswordReader.readPassword(null).toCharArray()).length == 0 || cArray.length == 1 && cArray[0] == '0') {
                                }
                            }
                        } while (!bl);
                        iMyPrivateKey = new AsymmetricCryptoKeyPair((PrivateKeyInfo)dERObject).getPrivate();
                    }
                    if (string != null || string2.getBagAttributes() == null) continue;
                    object2 = string2.getBagAttributes().getObjects();
                    while (object2.hasMoreElements()) {
                        object = (ASN1Sequence)object2.nextElement();
                        filterInputStream = (DERObjectIdentifier)object.getObjectAt(0);
                        dERObject = (DERObject)((ASN1Set)object.getObjectAt(1)).getObjectAt(0);
                        if (!filterInputStream.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) continue;
                        string = ((DERBMPString)dERObject).getString();
                    }
                }
            }
            if (x509CertificateStructure != null) {
                return new PKCS12(new AsymmetricCryptoKeyPair(iMyPrivateKey), JAPCertificate.getInstance(x509CertificateStructure));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public byte[] toByteArray() {
        return this.toByteArray("".toCharArray());
    }

    public byte[] toByteArray(boolean bl) {
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                byteArrayOutputStream.write(Base64.encode(this.toByteArray(), true).getBytes());
                byteArrayOutputStream.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byteArrayOutputStream.toByteArray();
        }
        return this.toByteArray();
    }

    public byte[] toByteArray(char[] cArray, boolean bl) {
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                byteArrayOutputStream.write(Base64.encode(this.toByteArray(cArray), true).getBytes());
                byteArrayOutputStream.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byteArrayOutputStream.toByteArray();
        }
        return this.toByteArray(cArray);
    }

    public byte[] toByteArray(char[] cArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.store(byteArrayOutputStream, cArray);
            ((OutputStream)byteArrayOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void store(OutputStream outputStream, char[] cArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (cArray == null) {
            cArray = new char[]{};
        }
        Object object = new byte[20];
        this.random.nextBytes((byte[])object);
        ContentInfo[] contentInfoArray = new PKCS12PBEParams(object, 100);
        Object object2 = PKCS12.codeData(true, this.m_keyPair.getPrivate().getEncoded(), (PKCS12PBEParams)contentInfoArray, cArray, (BlockCipher)new DESedeEngine(), 192);
        Object object3 = new AlgorithmIdentifier(new DERObjectIdentifier(KEY_ALGORITHM), (DEREncodable)contentInfoArray.getDERObject());
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(object3, object2);
        Object object4 = new DERSequence[2];
        MacData macData = new ASN1EncodableVector();
        macData.add((DEREncodable)PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
        macData.add((DEREncodable)new DERSet((DEREncodable)this.createSubjectKeyId()));
        object4[0] = new DERSequence((DEREncodableVector)macData);
        macData = new ASN1EncodableVector();
        macData.add((DEREncodable)PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
        macData.add((DEREncodable)new DERSet((DEREncodable)new DERBMPString(this.getAlias())));
        object4[1] = new DERSequence((DEREncodableVector)macData);
        DERSet dERSet = new DERSet((ASN1Encodable[])object4);
        BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString((DERObject)new DERSequence((DEREncodable)new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, encryptedPrivateKeyInfo.getDERObject(), (ASN1Set)dERSet)));
        contentInfoArray = (ContentInfo[])new byte[20];
        this.random.nextBytes((byte[])contentInfoArray);
        object2 = new PKCS12PBEParams((byte[])contentInfoArray, 100);
        object3 = new AlgorithmIdentifier(new DERObjectIdentifier(CERT_ALGORITHM), (DEREncodable)object2);
        encryptedPrivateKeyInfo = new CertBag(PKCSObjectIdentifiers.x509Certificate, (DERObject)new DEROctetString(this.m_x509certificate.getBouncyCastleCertificate()));
        object4 = new ASN1EncodableVector();
        object4.add((DEREncodable)PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
        object4.add((DEREncodable)new DERSet((DEREncodable)this.createSubjectKeyId()));
        macData = new DERSequence[2];
        macData[0] = new DERSequence((DEREncodableVector)object4);
        object4 = new ASN1EncodableVector();
        object4.add((DEREncodable)PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
        object4.add((DEREncodable)new DERSet((DEREncodable)new DERBMPString(this.getAlias())));
        macData[1] = new DERSequence((DEREncodableVector)object4);
        dERSet = new DERSet((ASN1Encodable[])macData);
        SafeBag safeBag = new SafeBag(PKCSObjectIdentifiers.certBag, encryptedPrivateKeyInfo.getDERObject(), (ASN1Set)dERSet);
        byteArrayOutputStream.reset();
        DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
        dEROutputStream.writeObject((Object)new DERSequence((DEREncodable)safeBag));
        dEROutputStream.close();
        byte[] byArray = PKCS12.codeData(true, byteArrayOutputStream.toByteArray(), (PKCS12PBEParams)object2, cArray, (BlockCipher)new RC2Engine(), 40);
        object = new EncryptedData(PKCSObjectIdentifiers.data, object3, (DEREncodable)new BERConstructedOctetString(byArray));
        contentInfoArray = new ContentInfo[]{new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)bERConstructedOctetString), new ContentInfo(PKCSObjectIdentifiers.encryptedData, (DEREncodable)object)};
        object2 = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)new BERConstructedOctetString((DEREncodable)new AuthenticatedSafe(contentInfoArray)));
        object3 = new byte[20];
        int n = 100;
        this.random.nextBytes((byte[])object3);
        object4 = ((DEROctetString)object2.getContent()).getOctets();
        macData = null;
        try {
            dERSet = new HMac((Digest)new SHA1Digest());
            safeBag = PKCS12.makePBEMacParameters(cArray, new PKCS12PBEParams((byte[])object3, n), 160);
            dERSet.init((CipherParameters)safeBag);
            dERSet.update((byte[])object4, 0, ((ASN1EncodableVector)object4).length);
            byArray = new byte[dERSet.getMacSize()];
            dERSet.doFinal(byArray, 0);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, null);
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
            macData = new MacData(digestInfo, (byte[])object3, n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        dERSet = new Pfx((ContentInfo)object2, macData);
        safeBag = new BEROutputStream(outputStream);
        safeBag.writeObject((Object)dERSet);
    }

    public String getAlias() {
        Vector<String> vector = new Vector<String>();
        X509DistinguishedName x509DistinguishedName = this.getSubject();
        vector.addElement(x509DistinguishedName.getCommonName());
        vector.addElement(x509DistinguishedName.getEmailAddress());
        vector.addElement(x509DistinguishedName.getOrganisation());
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null || ((String)vector.elementAt(i)).trim().length() == 0) continue;
            return (String)vector.elementAt(i);
        }
        return "alias unknown";
    }

    public X509Extensions getExtensions() {
        return this.m_x509certificate.getExtensions();
    }

    public X509DistinguishedName getSubject() {
        return this.m_x509certificate.getSubject();
    }

    public X509DistinguishedName getIssuer() {
        return this.m_x509certificate.getIssuer();
    }

    public IMyPrivateKey getPrivateKey() {
        return this.m_keyPair.getPrivate();
    }

    public IMyPublicKey getPublicKey() {
        return this.m_keyPair.getPublic();
    }

    public AsymmetricCryptoKeyPair getKeyPair() {
        return this.m_keyPair;
    }

    public JAPCertificate getX509Certificate() {
        return this.m_x509certificate;
    }

    public PKCS10CertificationRequest createCertifcationRequest() {
        return new PKCS10CertificationRequest(this);
    }

    public boolean setX509Certificate(JAPCertificate jAPCertificate) {
        if (jAPCertificate != null && ((Object)this.m_x509certificate.getPublicKey()).equals(jAPCertificate.getPublicKey())) {
            this.m_x509certificate = (JAPCertificate)jAPCertificate.clone();
            return true;
        }
        return false;
    }

    public void sign(PKCS12 pKCS12) {
        this.m_x509certificate = this.m_x509certificate.sign(pKCS12);
    }

    public void sign(PKCS12 pKCS12, Validity validity, X509Extensions x509Extensions, BigInteger bigInteger) {
        this.m_x509certificate = this.m_x509certificate.sign(pKCS12, validity, x509Extensions, bigInteger);
    }

    private static byte[] codeData(boolean bl, byte[] byArray, PKCS12PBEParams pKCS12PBEParams, char[] cArray, BlockCipher blockCipher, int n) throws IOException {
        byte[] byArray2;
        try {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher(blockCipher));
            CipherParameters cipherParameters = PKCS12.makePBEParameters(cArray, pKCS12PBEParams, paddedBufferedBlockCipher.getUnderlyingCipher().getAlgorithmName(), n, 64);
            cipherParameters = new ParametersWithRandom(cipherParameters, new SecureRandom());
            paddedBufferedBlockCipher.init(bl, cipherParameters);
            byte[] byArray3 = byArray;
            int n2 = byArray3.length;
            int n3 = 0;
            byte[] byArray4 = new byte[paddedBufferedBlockCipher.getOutputSize(n2)];
            if (n2 != 0) {
                n3 = paddedBufferedBlockCipher.processBytes(byArray3, 0, n2, byArray4, 0);
            }
            try {
                n3 += paddedBufferedBlockCipher.doFinal(byArray4, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray4, 0, byArray2, 0, n3);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray2;
    }

    private static CipherParameters makePBEMacParameters(char[] cArray, PKCS12PBEParams pKCS12PBEParams, int n) {
        PBEParametersGenerator pBEParametersGenerator = PKCS12.makePBEGenerator();
        byte[] byArray = PBEParametersGenerator.PKCS12PasswordToBytes((char[])cArray);
        pBEParametersGenerator.init(byArray, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
        CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(n);
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
        return cipherParameters;
    }

    private static CipherParameters makePBEParameters(char[] cArray, PKCS12PBEParams pKCS12PBEParams, String string, int n, int n2) {
        PBEParametersGenerator pBEParametersGenerator = PKCS12.makePBEGenerator();
        byte[] byArray = PBEParametersGenerator.PKCS12PasswordToBytes((char[])cArray);
        pBEParametersGenerator.init(byArray, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
        CipherParameters cipherParameters = n2 != 0 ? pBEParametersGenerator.generateDerivedParameters(n, n2) : pBEParametersGenerator.generateDerivedParameters(n);
        if (string.startsWith("DES")) {
            KeyParameter keyParameter;
            if (cipherParameters instanceof ParametersWithIV) {
                keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                DESParameters.setOddParity((byte[])keyParameter.getKey());
            } else {
                keyParameter = (KeyParameter)cipherParameters;
                DESParameters.setOddParity((byte[])keyParameter.getKey());
            }
        }
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
        return cipherParameters;
    }

    private static PBEParametersGenerator makePBEGenerator() {
        return new PKCS12ParametersGenerator((Digest)new SHA1Digest());
    }

    private static MyCipher getCipher(String string) {
        if (string.equals(KEY_ALGORITHM)) {
            return new MyCipher((BlockCipher)new DESedeEngine(), 192);
        }
        if (string.equals("1.2.840.113549.1.12.1.4")) {
            return new MyCipher((BlockCipher)new DESedeEngine(), 128);
        }
        if (string.equals("1.2.840.113549.1.12.1.5")) {
            return new MyCipher((BlockCipher)new RC2Engine(), 128);
        }
        if (string.equals(CERT_ALGORITHM)) {
            return new MyCipher((BlockCipher)new RC2Engine(), 40);
        }
        return null;
    }

    private SubjectKeyIdentifier createSubjectKeyId() {
        try {
            return new SubjectKeyIdentifier(this.m_x509certificate.getBouncyCastleSubjectPublicKeyInfo());
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    private static class MyCipher {
        public BlockCipher cipher;
        public int keysize;

        MyCipher(BlockCipher blockCipher, int n) {
            this.cipher = blockCipher;
            this.keysize = n;
        }
    }
}

