/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicDirectoryModel;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction = new NewFolderAction();
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private JFileChooser filechooser = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AncestorListener ancestorListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private BasicDirectoryModel model = null;
    private BasicFileView fileView = new BasicFileView();
    private JPanel accessoryPanel = null;

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return null;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        if (this.getFileChooser().getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (this.getFileChooser().getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        int n = this.getFileChooser().getApproveButtonMnemonic();
        return n;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = this.getFileChooser().getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (this.getFileChooser().getDialogType() == 0) {
            return this.openButtonText;
        }
        if (this.getFileChooser().getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        return this.getApproveButtonText(jFileChooser);
    }

    public String getDirectoryName() {
        return null;
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public String getFileName() {
        return null;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.model);
        this.ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JButton jButton = BasicFileChooserUI.this.getApproveButton(BasicFileChooserUI.this.getFileChooser());
                if (jButton != null) {
                    jButton.requestFocus();
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        };
        jFileChooser.addAncestorListener(this.ancestorListener);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicFileChooserUI.this.getFileChooser().cancelSelection();
            }

            public boolean isEnabled() {
                return BasicFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        jFileChooser.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected void installStrings(JFileChooser jFileChooser) {
        this.newFolderErrorText = UIManager.getString("FileChooser.newFolderErrorText");
        this.newFolderErrorSeparator = UIManager.getString("FileChooser.newFolderErrorSeparator");
        this.fileDescriptionText = UIManager.getString("FileChooser.fileDescriptionText");
        this.directoryDescriptionText = UIManager.getString("FileChooser.directoryDescriptionText");
        this.saveButtonText = UIManager.getString("FileChooser.saveButtonText");
        this.openButtonText = UIManager.getString("FileChooser.openButtonText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.updateButtonText = UIManager.getString("FileChooser.updateButtonText");
        this.helpButtonText = UIManager.getString("FileChooser.helpButtonText");
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.updateButtonMnemonic = UIManager.getInt("FileChooser.updateButtonMnemonic");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString("FileChooser.saveButtonToolTipText");
        this.openButtonToolTipText = UIManager.getString("FileChooser.openButtonToolTipText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelButtonToolTipText");
        this.updateButtonToolTipText = UIManager.getString("FileChooser.updateButtonToolTipText");
        this.helpButtonToolTipText = UIManager.getString("FileChooser.helpButtonToolTipText");
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void setDirectoryName(String string) {
    }

    public void setFileName(String string) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.model);
        jFileChooser.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        jFileChooser.removeAncestorListener(this.ancestorListener);
        this.ancestorListener = null;
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n);
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                } else {
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList;
            File file;
            if (!(listSelectionEvent.getValueIsAdjusting() || (file = (File)(jList = (JList)listSelectionEvent.getSource()).getSelectedValue()) == null || !BasicFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() && BasicFileChooserUI.this.getFileChooser().isTraversable(file))) {
                BasicFileChooserUI.this.getFileChooser().setSelectedFile(file);
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, String.valueOf(BasicFileChooserUI.this.newFolderErrorText) + BasicFileChooserUI.this.newFolderErrorSeparator + iOException, BasicFileChooserUI.this.newFolderErrorText, 0);
                return;
            }
            jFileChooser.rescanCurrentDirectory();
            jFileChooser.ensureFileIsVisible(file2);
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(null);
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().changeToParentDirectory();
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = BasicFileChooserUI.this.getFileName();
            FileSystemView fileSystemView = BasicFileChooserUI.this.getFileChooser().getFileSystemView();
            File file = BasicFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string != null && !string.equals("")) {
                File file2 = fileSystemView.createFileObject(string);
                if (!file2.isAbsolute()) {
                    file2 = fileSystemView.createFileObject(file, string);
                }
                if (file2.isDirectory() && BasicFileChooserUI.this.getFileChooser().isTraversable(file2) && !BasicFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                    BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(file2);
                } else if (!file2.isDirectory() && BasicFileChooserUI.this.getFileChooser().isFileSelectionEnabled() || file2.isDirectory() && BasicFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                    BasicFileChooserUI.this.getFileChooser().setSelectedFile(file2);
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
                return;
            }
            BasicFileChooserUI.this.getFileChooser().setSelectedFile(null);
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(BasicFileChooserUI.this.getDirectoryName()));
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache = new Hashtable();

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = file != null && file.isDirectory() ? (BasicFileChooserUI.this.getFileChooser().getFileSystemView().isRoot(file) ? BasicFileChooserUI.this.hardDriveIcon : BasicFileChooserUI.this.directoryIcon) : BasicFileChooserUI.this.fileIcon;
            this.cacheIcon(file, icon);
            return icon;
        }

        public String getName(File file) {
            String string = null;
            if (file != null && (string = file.getName()).equals("")) {
                string = file.getPath();
            }
            return string;
        }

        public String getTypeDescription(File file) {
            if (file.isDirectory()) {
                return BasicFileChooserUI.this.directoryDescriptionText;
            }
            return BasicFileChooserUI.this.fileDescriptionText;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean isTraversable(File file) {
            if (file.isDirectory()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

